'*****************
'433MHz Jaycar Transmitter
'Picaxe 08M2
'Phillip Webb 2012
'*****************
symbol checksum = B8
symbol TxPeriod = 15' 'Seconds between transmissions < 65535 (18 Hours)
symbol temp = w5
symbol analogin = w6
symbol EnCode = 149  'Encryption key
'***************************
main:
	
	Gosub GetData
	Gosub Transmit
goto main
'***************************
Transmit:  'Transmit subroutine.  Note Tx is off between transmissions to save power
	High 1 'Tx on 
	pause 10 'Tx delay for Rx to sense the Transmission and set AGC on
	low 1  'Tx off only for short period to keep Rx AGC low level to avoid noise Rx
	pause 1
	serout 1 , N2400_4, ("XYZ1",b0,b1,b2,b3,b4,b5,b6,b7,checksum) 'Send Station identifier, Data and Checksum
	low 1 'Switch Tx off. Save Power Rx AGC will be high gain thus Rx noise
	do ' Delay until next Tx 
	loop until time >= TxPeriod 
	time = 0 ' reset time 
return

'***************************
GetData:  ' Source the data and calculate checksum
	readADC10 2,analogin
	b4 = Encode + 0 'Tens thousands = 0
	b3 = analogin /1000 'Thousands
	b3 = b3 + encode + 168 'EnCode + other number 
	temp = analogin//1000
	b2= temp/100 'Hundreds
	b2 = b2 + encode + 15 'EnCode + other number 
	temp = temp//100
	b1= temp/10 'Tens
	b1 = b1 + encode + 231 'EnCode + other number 
	b0 = temp//10 'Units
	b0 = b0 + encode + 49 'EnCode + other number 
	
	
	'example below creates dummy data to send
	'b0 = b0 + 1
	'b1 = b0 + 1
	'b2 = b1 + 1
	'b3=  b2 + 1
	'b4 = b3 + 1
	'b5 = b4 + 1
	'b6 = b5 + 1
	'b7 = b6 + 1
	checksum = b0+ b1+b2+b3+b4+b5+b6+b7 ' calculate checksum
Return